import axios from  'axios';
import fs from 'fs';

class Api{

    static async getApi (id){
      var access_token = fs.readFileSync('token.txt', 'utf-8');
      var options = {
        params: {
          access_token: `${access_token}`
        },
      }
      try{
      const response = new Retorno((await axios.get(`https://www.grafipel.com.br/web_api/products/${id}`, options)).data.Product);
      return response;
      
      }
      catch(e){
        console.log("e");
      }
    }

    static async testApi (id){
      const response = await axios.get(`https://www.grafipel.com.br/web_api/products/${id}`)
      return response;
    }

    static async postApi   (id, marca, codigo_de_barras, nome_produto, peso_liquido, altura, largura, comprimento, 
      preço_venda, estoque_real, produto_imagem_1, produto_imagem_2, produto_imagem_3, produto_imagem_4, produto_imagem_5, 
      produto_imagem_6, descrição_completa_html, seo_descrição_simplificada, ncm, available, referência, 
      seo_palavras_chaves_do_produto, destaque, lançamento, categoria, iframe_produto, categoria_campanha, categoria_campanha2 ) {
      var access_token = fs.readFileSync('token.txt', 'utf-8');
      var options = {
        method: 'POST',
        url: 'https://trayparceiros.commercesuite.com.br/web_api/products/',
        params: {
          access_token: `${access_token}`
        },
        headers: {'Content-Type': 'application/json'},
        data: {
          Product: {
            id: `${id}`,
            brand: `${marca}`,
            ean: `${codigo_de_barras}`,
            name: `${nome_produto}`,
            weight: `${peso_liquido}`,
            height: `${altura}`,
            width: `${largura}`,
            length: `${comprimento}`,
            price: `${preço_venda}`,
            stock: `${estoque_real}`,
            picture_source_1: `${produto_imagem_1}`,
            picture_source_2: `${produto_imagem_2}`,
            picture_source_3: `${produto_imagem_3}`,
            picture_source_4: `${produto_imagem_4}`,
            picture_source_5: `${produto_imagem_5}`,
            picture_source_6: `${produto_imagem_6}`,
            description: `${descrição_completa_html}`,
            description_small: `${seo_descrição_simplificada}`,
            ncm: `${ncm}`,
            available: `${available}`,
            reference: `${referência}`,
            metatag: [{
              type: "keywords",
              content: `${seo_palavras_chaves_do_produto}`
            }],
            hot: `${destaque}`,
            release: `${lançamento}`,
            category_id: `${categoria}`,
            video: `${iframe_produto}`,
            related_categories: [`${categoria_campanha}, ${categoria_campanha2}`]
          }
        }
      };
      await axios.request(options).then(function (response) {
        console.log(response.data);
      }).catch(function (error) {
        console.error(error);
      });
    }

    static async updateApi (id, marca, codigo_de_barras, nome_produto, peso_liquido, altura, largura, comprimento, preço_venda, 
      estoque_real, produto_imagem_1, produto_imagem_2, produto_imagem_3, produto_imagem_4, produto_imagem_5, 
      produto_imagem_6, descrição_completa_html, seo_descrição_simplificada, ncm, available, referência, 
      seo_palavras_chaves_do_produto, destaque, lançamento, iframe_produto, categoria_campanha, categoria_campanha2) {
      var access_token = fs.readFileSync('token.txt', 'utf-8');  
      var options = {
        method: 'PUT',
        url: `https://www.grafipel.com.br/web_api/products/${id}`,
        params: {
          access_token: `${access_token}`
        },
        headers: {'Content-Type': 'application/json'},
        data: {
          Product: {
            id: `${id}`,
            brand: `${marca}`,
            ean: `${codigo_de_barras}`,
            name: `${nome_produto}`,
            weight: `${peso_liquido}`,
            height: `${altura}`,
            width: `${largura}`,
            length: `${comprimento}`,
            price: `${preço_venda}`,
            stock: `${estoque_real}`,
            picture_source_1: `${produto_imagem_1}`,
            picture_source_2: `${produto_imagem_2}`,
            picture_source_3: `${produto_imagem_3}`,
            picture_source_4: `${produto_imagem_4}`,
            picture_source_5: `${produto_imagem_5}`,
            picture_source_6: `${produto_imagem_6}`,
            description: `${descrição_completa_html}`,
            description_small: `${seo_descrição_simplificada}`,
            ncm: `${ncm}`,
            available: `${available}`,
            reference: `${referência}`,
            metatag: [{
              type: "keywords",
              content: `${seo_palavras_chaves_do_produto}`
            }],
            hot: `${destaque}`,
            release: `${lançamento}`,
            video: `${iframe_produto}`,
            related_categories: [`${categoria_campanha}, ${categoria_campanha2}`]
          }
        }
      };
      
      await axios.request(options).then(function (response) {
          console.log(response.data);
      }).catch(function (error) {
        console.error(error);
      });
      
    }

    static async inativaApi (id) {
      var access_token = fs.readFileSync('token.txt', 'utf-8');  
      var options = {
        method: 'PUT',
        url: `https://www.grafipel.com.br/web_api/products/${id}`,
        params: {
          access_token: `${access_token}`
        },
        headers: {'Content-Type': 'application/json'},
        data: {
          Product: {
            stock: "0",
            available: "0"
          }
        }
      };
      
      await axios.request(options).then(function (response) {
          console.log(response.data);
      }).catch(function (error) {
        console.error(error);
      });
      
    }

    static async zeraApi (id) {
      var access_token = fs.readFileSync('token.txt', 'utf-8');  
      var options = {
        method: 'PUT',
        url: `https://www.grafipel.com.br/web_api/products/${id}`,
        params: {
          access_token: `${access_token}`
        },
        headers: {'Content-Type': 'application/json'},
        data: {
          Product: {
            stock: "0"
          }
        }
      };
      
      await axios.request(options).then(function (response) {
          console.log(response.data);
      }).catch(function (error) {
        console.error(error);
      });
      
    }



}
class Retorno{
    constructor({id, price, stock})
    {
    this.id = id,
    this.price = price,
    this.stock = stock
    }
}
export default Api;